<?php

/**
 * WP self-hosted authentication
 *
 * @since 1.1.0
 */

defined( 'WP_UNINSTALL_PLUGIN' ) || exit;

$user_id = get_current_user_id();

if ( 0 == $user_id )  {
    return false;
}

// Prepares usermeta
$hashed_user_id = base64_encode( 'xit_sh_user_key_' . $user_id );

$auth_meta_key = "xit_wp_sh_auth_key_{$hashed_user_id}";

// Removes usermeta options
delete_user_meta( $user_id, $auth_meta_key );

// Clear cached data
wp_cache_flush();
